<?= view('layout/header') ?>

<style>
    .pendidikan-hero {
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
        padding: 50px 30px;
        border-radius: 30px;
        margin-bottom: 50px;
        position: relative;
        overflow: hidden;
        border: 1px solid rgba(255, 255, 255, 0.1);
    }

    .pendidikan-hero::before {
        content: '🎓';
        position: absolute;
        font-size: 15rem;
        opacity: 0.05;
        right: -50px;
        top: -50px;
        animation: float-emoji 6s ease-in-out infinite;
    }

    @keyframes float-emoji {
        0%, 100% { transform: translateY(0) rotate(0deg); }
        50% { transform: translateY(-20px) rotate(10deg); }
    }

    .hero-title {
        font-size: 3rem;
        font-weight: 900;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin-bottom: 10px;
        display: inline-flex;
        align-items: center;
        gap: 15px;
    }

    .hero-icon {
        font-size: 3rem;
        animation: pulse-icon 2s ease-in-out infinite;
    }

    @keyframes pulse-icon {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.1); }
    }

    .hero-subtitle {
        color: rgba(255, 255, 255, 0.6);
        font-size: 1.1rem;
        font-weight: 300;
    }

    .timeline-container {
        position: relative;
        padding: 20px 0;
    }

    .education-card {
        background: rgba(255, 255, 255, 0.03);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.1);
        border-radius: 25px;
        overflow: hidden;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        height: 100%;
        position: relative;
    }

    .education-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 5px;
        transition: all 0.4s ease;
    }

    .education-card.level-sd::before {
        background: linear-gradient(90deg, #f093fb, #f5576c);
    }

    .education-card.level-smp::before {
        background: linear-gradient(90deg, #4facfe, #00f2fe);
    }

    .education-card.level-sma::before {
        background: linear-gradient(90deg, #43e97b, #38f9d7);
    }

    .education-card.level-kuliah::before {
        background: linear-gradient(90deg, #667eea, #764ba2);
    }

    .education-card:hover {
        transform: translateY(-10px) scale(1.02);
        box-shadow: 0 20px 60px rgba(102, 126, 234, 0.3);
        border-color: rgba(102, 126, 234, 0.3);
    }

    .education-card:hover::before {
        height: 100%;
        opacity: 0.1;
    }

    .card-header-custom {
        padding: 25px 25px 20px 25px;
        text-align: center;
    }

    .level-badge {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        padding: 10px 20px;
        border-radius: 25px;
        font-weight: 700;
        font-size: 0.9rem;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 20px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .badge-sd {
        background: linear-gradient(135deg, #f093fb, #f5576c);
        color: white;
    }

    .badge-smp {
        background: linear-gradient(135deg, #4facfe, #00f2fe);
        color: white;
    }

    .badge-sma {
        background: linear-gradient(135deg, #43e97b, #38f9d7);
        color: white;
    }

    .badge-kuliah {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .logo-container {
        width: 100px;
        height: 100px;
        margin: 0 auto 20px auto;
        border-radius: 20px;
        background: rgba(255, 255, 255, 0.05);
        border: 2px solid rgba(255, 255, 255, 0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        transition: all 0.3s ease;
        position: relative;
    }

    .education-card:hover .logo-container {
        transform: scale(1.1);
        box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
    }

    .logo-container img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        padding: 10px;
    }

    .logo-placeholder {
        font-size: 3rem;
        opacity: 0.3;
    }

    .school-name {
        font-size: 1.3rem;
        font-weight: 700;
        color: rgba(255, 255, 255, 0.9);
        margin-bottom: 10px;
        line-height: 1.4;
        min-height: 60px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .school-major {
        color: rgba(255, 255, 255, 0.6);
        font-size: 0.95rem;
        font-weight: 500;
        margin-bottom: 15px;
        font-style: italic;
        min-height: 25px;
    }

    .year-range {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        background: rgba(255, 255, 255, 0.05);
        padding: 12px 20px;
        border-radius: 20px;
        font-weight: 600;
        color: rgba(255, 255, 255, 0.7);
        font-size: 0.9rem;
        margin-top: 20px;
    }

    .year-separator {
        color: rgba(255, 255, 255, 0.4);
        font-weight: 300;
    }

    .empty-state {
        text-align: center;
        padding: 80px 40px;
        background: rgba(255, 255, 255, 0.03);
        border-radius: 25px;
        border: 2px dashed rgba(255, 255, 255, 0.1);
    }

    .empty-icon {
        font-size: 5rem;
        margin-bottom: 20px;
        opacity: 0.3;
    }

    .empty-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: rgba(255, 255, 255, 0.7);
        margin-bottom: 10px;
    }

    .empty-text {
        color: rgba(255, 255, 255, 0.5);
        font-size: 1rem;
    }

    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid rgba(255, 255, 255, 0.1);
        color: rgba(255, 255, 255, 0.8);
        padding: 14px 30px;
        border-radius: 25px;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
        margin-top: 30px;
    }

    .back-button:hover {
        background: rgba(255, 255, 255, 0.1);
        border-color: rgba(102, 126, 234, 0.5);
        color: white;
        transform: translateX(-5px);
    }

    .back-icon {
        font-size: 1.2rem;
        transition: transform 0.3s ease;
    }

    .back-button:hover .back-icon {
        transform: translateX(-5px);
    }

    .education-card {
        animation: fadeInUp 0.6s ease forwards;
        opacity: 0;
    }

    .education-card:nth-child(1) { animation-delay: 0.1s; }
    .education-card:nth-child(2) { animation-delay: 0.2s; }
    .education-card:nth-child(3) { animation-delay: 0.3s; }
    .education-card:nth-child(4) { animation-delay: 0.4s; }
    .education-card:nth-child(5) { animation-delay: 0.5s; }
    .education-card:nth-child(6) { animation-delay: 0.6s; }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    @media (max-width: 768px) {
        .hero-title {
            font-size: 2rem;
        }

        .hero-icon {
            font-size: 2rem;
        }

        .pendidikan-hero {
            padding: 30px 20px;
        }

        .school-name {
            font-size: 1.1rem;
            min-height: 50px;
        }

        .logo-container {
            width: 80px;
            height: 80px;
        }

        .level-badge {
            font-size: 0.8rem;
            padding: 8px 16px;
        }
    }
</style>

<div class="pendidikan-hero">
    <h1 class="hero-title">
        <span class="hero-icon">🎓</span>
        Riwayat Pendidikan
    </h1>
    <p class="hero-subtitle">Perjalanan pendidikan formal yang telah ditempuh</p>
</div>

<?php if ($pendidikan): ?>
    <div class="row g-4 mb-5">
        <?php foreach ($pendidikan as $p): ?>
            <?php
            $levelClass = strtolower($p['jenjang']);
            $badgeClass = 'badge-' . $levelClass;
            
            $icons = [
                'sd' => '📚',
                'smp' => '📖',
                'sma' => '🎒',
                'kuliah' => '🎓'
            ];
            $icon = $icons[$levelClass] ?? '📘';
            ?>
            
            <div class="col-md-6 col-lg-4">
                <div class="education-card level-<?= $levelClass ?>">
                    <div class="card-header-custom">
                        <!-- Level Badge -->
                        <span class="level-badge <?= $badgeClass ?>">
                            <span><?= $icon ?></span>
                            <span><?= esc($p['jenjang']) ?></span>
                        </span>

                        <div class="logo-container">
                            <?php if (!empty($p['logo_sekolah'])): ?>
                                <img src="<?= base_url('uploads/pendidikan/' . esc($p['logo_sekolah'])) ?>"
                                    alt="Logo <?= esc($p['nama_sekolah']) ?>">
                            <?php else: ?>
                                <span class="logo-placeholder">🏫</span>
                            <?php endif; ?>
                        </div>

                        <h5 class="school-name">
                            <?= esc($p['nama_sekolah']) ?>
                        </h5>

                        <div class="school-major">
                            <?= !empty($p['jurusan']) ? esc($p['jurusan']) : '&nbsp;' ?>
                        </div>

                        <div class="year-range">
                            <span>📅</span>
                            <span><?= esc($p['tahun_masuk']) ?></span>
                            <span class="year-separator">—</span>
                            <span><?= esc($p['tahun_lulus']) ?></span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach ?>
    </div>
<?php else: ?>
    <div class="empty-state">
        <div class="empty-icon">📭</div>
        <h3 class="empty-title">Belum Ada Data Pendidikan</h3>
        <p class="empty-text">Data riwayat pendidikan belum tersedia saat ini</p>
    </div>
<?php endif; ?>

<div class="text-center">
    <a href="<?= base_url('/') ?>" class="back-button">
        <span class="back-icon">←</span>
        <span>Kembali ke Home</span>
    </a>
</div>

<?= view('layout/footer') ?>